﻿IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CPJ_Cbtes_Lotes_Cobranza]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CPJ_Cbtes_Lotes_Cobranza] 
END
GO

CREATE PROCEDURE [dbo].[CPJ_Cbtes_Lotes_Cobranza] @pJson VARCHAR(8000)
AS
SET NOCOUNT ON

DECLARE @pFlagUsarTrans		TINYINT
DECLARE @pModoDebug			TINYINT
DECLARE @pId_Usuario		SMALLINT
DECLARE @pId_Cliente		INT
DECLARE @pLote				VARCHAR(29)
DECLARE @pFecha				DATETIME
DECLARE @pDescripcion		VARCHAR(50)
DECLARE @pId_Lote_Tipo		SMALLINT
DECLARE @pId_Periodo_Caja	INT
DECLARE @pFecha_Rec			DATETIME
DECLARE @pId_Tipo_Cbte		CHAR(4)
DECLARE @pId_Moneda			CHAR(3)
DECLARE @pCotizacion		DECIMAL(9, 4)
DECLARE @pId_Tipo_Val		CHAR(3)
DECLARE @pImporte			DECIMAL(16,2)
DECLARE @pId_Tarjeta		VARCHAR(10)
DECLARE @pId_Cta_banco      INT
DECLARE @pId_Cobrador		VARCHAR(10) 
DECLARE @pCbte_Nro_Externo	VARCHAR(25)

SET @pFlagUsarTrans			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Usuario			= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Usuario')), 0)
SET @pLote					= ISNULL(CONVERT(VARCHAR(29),dbo.CF_JSON_VALUE(@pJson,'Lote')),'')
SET @pId_Cliente			= ISNULL(CONVERT(INT,dbo.CF_JSON_VALUE(@pJson,'Id_Cliente')),0)
SET @pFecha					= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha')),'19000101')
SET @pDescripcion			= ISNULL(CONVERT(VARCHAR(50), dbo.CF_JSON_VALUE(@pJson,'Descripcion')), '')
SET @pId_Lote_Tipo			= ISNULL(CONVERT(SMALLINT,dbo.CF_JSON_VALUE(@pJson,'Id_Lote_Tipo')),0)
SET @pId_Periodo_Caja		= ISNULL(CONVERT(INT,dbo.CF_JSON_VALUE(@pJson,'Id_Periodo_Caja')),0)
SET @pFecha_Rec				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Rec')),'19000101')
SET @pId_Tipo_Cbte			= ISNULL(CONVERT(CHAR(4), dbo.CF_JSON_VALUE(@pJson,'Lote')), '')
SET @pId_Moneda				= ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Id_Moneda')), '')
SET @pCotizacion			= ISNULL(CONVERT(DECIMAL(12,4), dbo.CF_JSON_VALUE(@pJson,'Cotizacion')), 0)
SET @pId_Tipo_Val			= ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Id_Tipo_Val')), '')
SET @pImporte				= ISNULL(CONVERT(DECIMAL(15,2), dbo.CF_JSON_VALUE(@pJson,'Importe')), 0)
SET @pId_Tarjeta			= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_Tarjeta')), '')
SET @pId_Cta_banco			= ISNULL(CONVERT(INT,dbo.CF_JSON_VALUE(@pJson,'Id_Cta_banco')),0)
SET @pId_Cobrador			= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_Cobrador')), '')
SET @pCbte_Nro_Externo		= ISNULL(CONVERT(VARCHAR(25), dbo.CF_JSON_VALUE(@pJson,'Cbte_Nro_Externo')), '')
/*Fin Declaracion Variables Json*/

/*Variable de Retorno del Stored*/
DECLARE @rtaErrorStored			INT
DECLARE @rtaMsjStored			VARCHAR(4000)
/*FIN Variable de Retorono del Stored*/

/*Declaracion Variables Locales*/

DECLARE @Mensaje			VARCHAR(100)
		,@UltError			INT
		,@Id_Trans			INT
		,@Id_Cliente		INT
		,@Importe			DECIMAL(16,2)
		,@Email_Cob			VARCHAR(256)
		,@Id_Trans_Rec		INT
		,@CursorOpen        INT


  DECLARE @Respuesta Table (
				ErrorNumber		INT,
				ErrorSeverity	INT,
				ErrorState		INT,
				ErrorProcedure  VARCHAR(1000),
				ErrorLine		INT,
				ErrorMessage	VARCHAR(1000)
				)

BEGIN TRY
	BEGIN TRAN
	
	PRINT 'CPJ_Cbtes_Lotes_Cobranza'

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Cbtes_Lotes_Cobranza'
		PRINT 'Parámetros:'
		PRINT '@pId_Cliente: ' + CONVERT(VARCHAR(10),@pId_Cliente) + '.@pLote: ' + @pLote + ' pFecha: ' + CONVERT(VARCHAR(10), @pFecha, 103) + '@pDescripcion: ' + @pDescripcion + 'pId_Lote_Tipo: ' + CONVERT(CHAR(3), @pId_Lote_Tipo) + '@pId_Periodo_Caja: ' + CONVERT(VARCHAR(10),@pId_Periodo_Caja) + '@pFecha_Rec: ' + CONVERT(VARCHAR(10),@pFecha_Rec,103) + 'pId_Tipo_Cbte: ' + @pId_Tipo_Cbte +  ' pId_Moneda: ' + @pId_Moneda + ' pCotizacion: ' + CONVERT(VARCHAR(20), @pCotizacion) + 'pId_Tipo_Val: ' + @pId_Tipo_Val +'pImporte:  ' + CONVERT(VARCHAR(50),@pImporte) + '@pId_Tarjeta: ' + @pId_Tarjeta + '@pId_Cta_banco: ' + CONVERT(VARCHAR(10),@pId_Cta_banco) +'@pId_Cobrador: ' + @pId_Cobrador + 'pCbte_Nro_Externo: ' + @pCbte_Nro_Externo
	END

	/*Recorrer los tagueados */

	DECLARE TagCbtesCursor CURSOR FOR
		SELECT T.Ptr AS Id_Trans, C.Id_Cliente,T.Importe , C.Email_Cob
				FROM TagFile_ T , Clientes C
				WHERE Tbl = 300 AND Usr = @pUsuario
				AND C.Id_Cliente = CAST(T.Val AS INT)

	OPEN TagCbtesCursor

	FETCH NEXT FROM TagCbtesCursor INTO @Id_Trans,@Id_Cliente,@Importe,@Email_Cob
	SET @CursorOpen = 0	
	SET @UltError = 0
	WHILE @@FETCH_STATUS=0 AND @UltError  = 0
	BEGIN
	        SET @CursorOpen = 1	

		    SET @Id_Trans_Rec = 0

			DELETE @Respuesta
			INSERT INTO @Respuesta
			EXEC @UltError = CPJ_Cbtes_Rec_Generar @pJson
			IF @UltError <> 0
				BEGIN
					ROLLBACK
					SELECT * FROM @Respuesta	
					RETURN 4567
				END
			ELSE	
				SELECT TOP 1 @Id_Trans_Rec = ErrorLine FROM @Respuesta

            IF @Id_Trans_Rec = 0
			BEGIN
				ROLLBACK
				SELECT	 4568			AS ErrorNumber 
						,0				AS ErrorSeverity  
						,0				AS ErrorState 
						,0				AS ErrorProcedure  
						,0				AS ErrorLine		
						,'No se genero el numero de trans recibo'		AS ErrorMessage
				RETURN 4568
			END


			DELETE @Respuesta
			INSERT INTO @Respuesta
			EXEC @UltError = CPJ_Cbtes_Rec_Generar_Item @pJson
			IF @UltError <> 0
			BEGIN
				ROLLBACK
				SELECT * FROM @Respuesta	
				RETURN 4569
			END


			DELETE @Respuesta
			INSERT INTO @Respuesta
			EXEC @UltError = CPJ_Cbtes_Rec_Generar_Pago @pJson
			IF @UltError <> 0
			BEGIN
				ROLLBACK
				SELECT * FROM @Respuesta	
				RETURN 4570
			END


			DELETE @Respuesta
			INSERT INTO @Respuesta
			EXEC @UltError = CPJ_Cbtes_Rec_Fin @pJson
			IF @UltError <> 0
			BEGIN
				ROLLBACK
				SELECT * FROM @Respuesta	
				RETURN 4571
			END

   			FETCH NEXT FROM TagCbtesCursor INTO @Id_Trans,@Id_Cliente,@Importe,@Email_Cob	

	END
	CLOSE TagCbtesCursor
	DEALLOCATE TagCbtesCursor
	SET @CursorOpen = 0	

	/*Actualizar Lote con fecha de fin y [Flag_enProceso] en 0 y totales */
	UPDATE Cbtes_Lotes SET	Cantidad = (SELECT COUNT(*) FROM Cbtes WHERE Lote = @pLote) ,
							Importe =  (SELECT SUM(Imp_Total) FROM Cbtes WHERE Lote = @pLote),
							Fecha_Finalizacion = GETDATE(),
							Flag_enProceso = 0
			WHERE Lote = @pLote


	/******************************fin del proceso***********************************************/


	/*******************    En caso de error deberia grabar en la tablla cbtes_errores ***********************/

	
COMMIT

	SET @Mensaje = (SELECT DATEDIFF(s,Fecha_Inicio,Fecha_Finalizacion) FROM CBTES_LOTES WHERE LOTE = @pLote)

	SELECT	 0				AS ErrorNumber 
			,0				AS ErrorSeverity  
			,0				AS ErrorState 
			,0				AS ErrorProcedure  
			,0				AS ErrorLine		
			,@Mensaje		AS ErrorMessage

IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Cbtes_Lotes_Cobranza'
	END	
END TRY  

END TRY  


BEGIN CATCH  
    
    EXECUTE usp_GetErrorInfo
	
	UPDATE Cbtes_Lotes SET	Cantidad = (SELECT COUNT(*) FROM Cbtes WHERE Lote = @pLote) ,
							Importe =  (SELECT SUM(Imp_Total) FROM Cbtes WHERE Lote = @pLote),
							Fecha_Finalizacion = GETDATE(),
							Flag_enProceso = 0
			WHERE Lote = @pLote

      IF @CursorOpen = 1
	     BEGIN 
		 	CLOSE TagCbtesCursor
	        DEALLOCATE TagCbtesCursor
         END
		 	
	RETURN 9999
END CATCH

RETURN 0


